<?php
namespace Void_ewhmcsep\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Domain_Price extends Widget_Base {

	public function get_name() {
		return 'section-domain-price'; 
	}

	public function get_title() {
		return 'Domain TLD Price';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-table';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'void-elements' ];    // category of the widget
	}
	public function get_script_depends() {
		return [ 'domain-search'];
	}
	
	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Settings', 'void_ewhmcsep' ),   //section name for controler view
			]
		);

		$this->add_control(
			'whmcs_url',
			[
				'label' => __( 'WHMCS URL', 'void_ewhmcsep' ),
				'description' => __( 'Used to get/send data from any whmcs installation!. Do not add (/). Just input direct url of your whmcs area (not admin url). ex: https://testsite/whmcs .Live preview will now work for this. Only when you view the site you will see that it fatches the data!', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'https://voidcoders.com/voidwhmcs',
			]
		);

		$this->add_control(
			'currency_number',
			[
				'label' => __( 'Currency Number', 'void_ewhmcsep' ),
				'description' => __( 'The currency number from your WHMCS. Generally the default currency is numbered - 1', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '1',
			]
		);

		$this->add_control(
			'search_on',
			[
				'label' => __( 'Show Search', 'void_ewhmcsep' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'void_ewhmcsep' ),
				'label_off' => __( 'Hide', 'void_ewhmcsep' ),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'search_2',
			[
				'label' => __( 'Allow dot (.) before TLD', 'void_ewhmcsep' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'void_ewhmcsep' ),
				'label_off' => __( 'No', 'void_ewhmcsep' ),
				'return_value' => 'dotallowed',
				'condition' => [
                    'search_on' => [ '1'],
                ],
			]
		);

		$this->add_control(
			'search_bar_placeholder',
			[
				'label' => __( 'Search Bar Placeholder', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Search TLD',
				'condition' => [
								'search_on' => '1',
							],			
			]
		);
		
		$this->end_controls_section();

//End  of a control box

//start of a control box
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'void_ewhmcsep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'search_input_bg_color',
			[
				'label' => __( 'Search Box Background Color', 'void_ewhmcsep' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} input[type="text"]' => 'background: {{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);	

		$this->add_control(
			'search_input_text_color',
			[
				'label' => __( 'Search Box Input Text Color', 'void_ewhmcsep' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} input[type="text"]' => 'color: {{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);		

		$this->add_control(
			'search_input_placeholder_color',
			[
				'label' => __( 'Search Box Placeholder Color', 'void_ewhmcsep' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} input[type="text"]::placeholder' => 'color: {{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);	
	

		$this->add_control(
			'search_input_border',
			[
				'label' => __( 'Search Box Border Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> '1px solid red; ',
				'selectors' => [
					'{{WRAPPER}} input[type="text"]' => 'border: {{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);	

		$this->add_responsive_control(
			'search_box_alignment',
			[
				'label' => __( 'Search box Alignment', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementor-pro' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementor-pro' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementor-pro' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'condition' => [ 'search_on' => '1', ],
				'selectors' => [
									'{{WRAPPER}} .void-wehmcsep-search-box' => 'text-align: {{VALUE}};',
								],
			]
		);	

		$this->add_control(
			'search_width',
			[
				'label' => __( 'Search Box Width', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
			            'px' => [
			                'min' => 0,
			                'max' => 10000,
			                'step' => 5,
			            ],
			            '%' => [
			                'min' => 0,
			                'max' => 100,
			            ],
			        ],
			        'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} input[type="text"]' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);

		$this->add_control(
			'search_extra1',
			[
				'label' => __( 'Search Box Main Div CSS', 'elementor-pro' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => 'background:#000;', 
				'selectors' => [
					'{{WRAPPER}} .void-wehmcsep-search-box' => '{{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);	

		$this->add_control(
			'search_extra',
			[
				'label' => __( 'Search Box Input CSS', 'elementor-pro' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => 'width:100%;', 
				'selectors' => [
					'{{WRAPPER}} input[type="text"]' => '{{VALUE}};',
				],
				'condition' => [ 'search_on' => '1', ],
			]
		);

		$this->add_control(
			'table_css1',
			[
				'label' => __( 'Table Heading Background', 'void_ewhmcsep' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} table.domainpricing th' => 'background-color: {{VALUE}};',
				],
			]
		);	
		$this->add_control(
			'table_css2',
			[
				'label' => __( 'Table Heading Text Color', 'void_ewhmcsep' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} table.domainpricing th' => 'color: {{VALUE}};',
				],
			]
		);	
		$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography',
					'label' => __( 'Table Heading Typography', 'void_ewhmcsep' ),
					'selector' => '{{WRAPPER}} table.domainpricing th',
				]
		);	

		$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography1',
					'label' => __( 'Table Rows Typography', 'void_ewhmcsep' ),
					'selector' => '{{WRAPPER}} table.domainpricing td',
				]
		);
		
		$this->end_controls_section();



	}

//end of control box 

protected function render() {		
			//to show on the fontend 	
	$settings = $this->get_settings();
	if(empty($settings['currency_number'])){
		$settings['currency_number']=0;
	}
	?>
	
	<?php if(!empty($settings['search_on']) ): ?>
	<div class="void-wehmcsep-search-box">
		<input type="text" class="void-ewhmcsep-domain-table-search <?php echo $settings['search_2']; ?>" autocomplete="off" placeholder="<?php echo $settings['search_bar_placeholder']; ?>">
	</div>
	<?php endif; ?>

	<div class="void-ewhmcsep-domain-table ewhmcs-domain-tld-<?php echo $this->get_id(); ?>">
		<?php if( $settings['whmcs_url']!='' ) {
			
			if(\Elementor\Plugin::$instance->editor->is_edit_mode()){
				echo 'Dynamic Data will be shown in original view';
			}else{
		 		echo'<script language="javascript" src="'.$settings['whmcs_url'].'/feeds/domainpricing.php?&currency='.$settings['currency_number'].'"></script>'; 

			}
		
		} 
		?>
	</div>

	<?php	}

	protected function content_template() {      // to be in live preview edit
	
	}
}
